/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package edu.unl.consystlab.sudokuSolver;

import java.awt.Container;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import com.Ostermiller.util.*;


/**
 * The about box
 * @author Robert
 * @version 1.0
 */
public class AboutBox extends JFrame implements HyperlinkListener {

	/**
	 * Serial Version
	 */
	private static final long serialVersionUID = 5808260253143493840L;

	public final static String ABOUT_TEXT = "<html>\r\n" +
		"<div align=center>\r\n" +
		"Sudoku Solver & Constructor<br />\r\n" +
		"Jason Gaare (2008-Present)<br />\r\n" +
		"Kenneth M. Bayer (2007)<br />\r\n" +
        "Kai-Chen (Angelo) Huang (2007)<br />\r\n" +
        "Christopher G. Reeson (2006-2007)<br />\r\n" +
		"Berthe Y. Choueiry<br />\r\n" +
		"Constraint Systems Laboratory (ConSystLab - <a href=\"http://consystlab.unl.edu/\">http://consystlab.unl.edu/</a>)<br />\r\n" +
		"Homepage: <a href=\"http://sudoku.unl.edu\">http://sudoku.unl.edu</a><br />\r\n" +
		"Please report any bugs to sudoku [at] cse [dot] unl [dot] edu\r\n" +
		"</div>\r\n" +
		"</html>";

	public AboutBox()
	{
		setTitle("About");
		setDefaultCloseOperation(HIDE_ON_CLOSE);
		setVisible(false);
		setSize(450, 200);
		setLocation(200, 300);
		setResizable(false);

		Container contentPane = getContentPane();

		JEditorPane aboutText = new JEditorPane("text/html", ABOUT_TEXT);
		aboutText.setEditable(false);
		aboutText.addHyperlinkListener(this);
		contentPane.add(aboutText);
	}

	public void hyperlinkUpdate(HyperlinkEvent arg0)
	{
		if(arg0.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
		{
			try {
				Browser.init();
				Browser.displayURL(arg0.getDescription());
			} catch (IOException e) {
				// Could not launch the link...
			}
		}
	}
}

